#!/usr/bin/env python3

import tkinter as tk     ## Python 3.x
import sys as sys
from PIL import ImageTk, Image
import os as os
import glob as glob
from tkinter.scrolledtext import ScrolledText
# import easygui as ez
import ntpath as nt

# Config parameters for screens
swf=0.6
shf=0.90
scrolline=5
frallow=280
frn=0.25

def myexit():
    root.destroy()
    sys.exit(0)

def myhelp():
    msg="""
This is JNJpgCom, a program to display JPG images
and allow the COMment field to be edited or added.
The program is by Prof. John C. Nash,
Telfer School of Management,
University of Ottawa,
nashjc _at_ uottawa.ca.
Released under GPL2  2020-7-10
"""
#       adds label at bottom
#       hdisp=Label(window, text=tt)
#       hdisp.pack()
    popup = tk.Tk()
    popup.wm_title("JpgComJN - Help")
    pframe1=tk.Frame(popup)
    pframe1.pack()
    pframe1.label = tk.Text(pframe1, height=10, width=50)
    pframe1.label.insert(tk.END, msg)
    pframe1.label.pack(side=tk.LEFT, fill=tk.BOTH, padx=1, pady=1)
    pframe2=tk.Frame(popup)
    pframe2.pack()
    pframe2.B1 = tk.Button(pframe2, text="Ok", command = popup.destroy)
    pframe2.B1.pack()
    popup.mainloop()

def myerror():
    global errstr
    msg="ERROR! "+errstr
    epop = tk.Tk()
    epop.wm_title("JpgComJN - Help")
    epf1=tk.Frame(epop)
    epf1.pack()
    epf1.label = tk.Text(epf1, height=10, width=50)
    epf1.label.insert(tk.END, msg)
    epf1.label.pack(side=tk.LEFT, fill=tk.BOTH, padx=1, pady=1)
    epf2=tk.Frame(epop)
    epf2.pack()
    epf2.B1 = tk.Button(pframe2, text="Exit", command = myexit)
    epf2.B1.pack()
    epop.mainloop()

def mywrjpgcom(txtcom):
    global fname
    global errstr
    # write txtcom into jpg comment string in output file ofn
    ofn = "__tmp__"+fname
#    sysstr="wrjpgcom -replace -comment '"+txtcom+"' "+fname+" >"+ofn # BAD!
    sysstr='wrjpgcom -replace -comment "'+txtcom+'" '+fname+" >"+ofn
    # Note use of quotes -- problem with apostrophe. May still
    print(sysstr)
    test=os.system(sysstr)
    if test > 0:
        errstr="wrjpgcom failed code "+str(test)
        bang=myerror()
    cpy=os.system("mv "+ofn+" "+fname)
    ## If cpy not 0 should popup error box??
    print(cpy)
    if cpy > 0:
        errstr="wrjpgcom failed code "+str(cpy)
        bang=myerror()
    
def mycom(jpgfname):
    jimg = Image.open(jpgfname)
    mdata=jimg.app
    if ("COM" in mdata):
        tt=mdata["COM"]
        tt=tt.decode()
    else:
        tt=""
    return(tt)

counter = 0

print(os.getcwd())
jpglist=[]
for f in glob.glob("*.jpg"):
    jpglist.append(f)
if len(jpglist)==0:
    print("NO JPG FILES!")
    sys.exit(0)
jpglist.sort()

# ez.msgbox(str(sys.argv))

if len(sys.argv)==2:
    ifn = sys.argv[1]
    # get just filename without full path
#    ez.msgbox(ifn)
    ifn=nt.basename(ifn)
#    ez.msgbox(ifn)
    tcount=jpglist.count(ifn)
    if tcount==1:
        idx=jpglist.index(ifn)
    else:
        idx=0 # start at beginning if not present (Give warning?)
else:
    idx=0

nimg = len(jpglist)    

def myimsize(img):
# want to adjust image to fit available space    
    global maxw
    global maxh
    maxframe=maxh-max(frallow, int(frn*maxh))
    imgw=img.size[0] # width
    imgh=img.size[1] # height
#    print("imgw and imgh:"+str(imgw)+"  "+str(imgh))
    if imgw <= maxw:
#        print("imgw OK")
        if imgh <= maxframe:
#            print("imgw OK, imgh OK")
            ww = imgw
            wh = imgh
        else:
#            print("reduce height then width")
            wfrac=maxframe/float(imgh)
            wh=int(imgh*float(wfrac))
            ww=int(float(imgw)*float(wfrac))
    else:
#        print("imgw too big")
        if float(imgw/maxw) > float(imgh/maxframe): # height is dominant
            wfrac=maxw/float(imgw)
            wh=int(float(imgh)*float(wfrac))
            ww=int(float(imgw)*float(wfrac))
        else:
            wfrac=maxframe/float(imgh)
            wh=int(float(imgh)*float(wfrac))
            ww=int(float(imgw)*float(wfrac))
#    print("myimsize - width and height:"+str(ww)+"  "+str(wh))
    whlist=[ww, wh]
    return(whlist)

def myget():
    global edcom
    global fname
    txtret=edcom.get('1.0', 'end-1c')
    print(txtret)
    ## At this point prints, but does not seem to save anywhere
    ofn="_temp_.jpg"
    mywrjpgcom(txtret)

def frenam():
    global jpglist
    global idx
    global fname
    global namlbl
    global jpglist
    txtnam=namlbl.get()
    print("New name="+txtnam)
    cpy=os.system("mv "+fname+" "+txtnam)
    fname=txtnam
    if cpy > 0:
        sys.exit(99)
    jpglist[idx]=fname.encode() # need as bytes
#    jpglist=[]
#    for f in glob.glob("*.jpg"):
#        jpglist.append(f)
#    if len(jpglist)==0:
#        print("NO JPG FILES!")
#        sys.exit(0)
#    jpglist.sort()
                        

class ReplaceTest():
    def __init__(self, top):
        global counter
        global idx
        global timg
        global maxw
        global maxh
        global edcom
        global fname
        global namlbl
        global scrolline
        fname=str(jpglist[idx])
        comtxt=mycom(fname)
        self.top=top
        self.top.geometry("800x700+100+100")
        self.top.title("JNImgCom")
        self.bframe=tk.Frame(self.top)
        self.bframe.pack(side=tk.TOP)
        dtxtL=str(fname)
        ntxt=str("Next "+str(counter+1))
        ptxt=str("Prev "+str(counter-1))
        next_button=tk.Button(self.bframe, text=ntxt, command=self.next)
        next_button.pack(padx=10, pady=5, side=tk.LEFT)
        prev_button=tk.Button(self.bframe, text=ptxt, command=self.prev)
        prev_button.pack(padx=10, pady=5, side=tk.LEFT)
        exit_button=tk.Button(self.bframe, text="Exit", command=myexit)
        exit_button.pack(padx=10, pady=5, side=tk.LEFT)
        help_button = tk.Button(self.bframe, text=" Help (?) ", fg="red", command=myhelp)
        help_button.pack(padx=10, pady=5, side=tk.LEFT)
        self.frame=tk.Frame(self.top, takefocus=True)
        self.frame.pack()
        self.namfram=tk.Frame(self.frame, takefocus=True) # ? do we need focus
        self.namfram.pack(side=tk.TOP)
        dtxtL=str(fname)
        vnam=tk.StringVar(self.namfram, dtxtL)
        namlbl=tk.Entry(self.namfram, textvariable=vnam, bg="Blue", fg="White")
        namlbl.pack(side=tk.LEFT)
        rbut=tk.Button(self.namfram, text=" Rename ", command=frenam)
        rbut.pack(side=tk.LEFT)
        print("INIT Opening "+fname)
        img=Image.open(fname)
        [wsize, hsize]=myimsize(img)
        print("image size ="+str(wsize)+" x "+str(hsize))
        timg = img.resize((wsize,hsize), Image.ANTIALIAS)
        timg=ImageTk.PhotoImage(timg)
        dimg=tk.Label(self.frame, image=timg)
        dimg.image=timg # keeping a reference (needed!!??)
        dimg.pack()
        # Add comment edit
        edcom=tk.Label(self.frame, text="ScrolledText Box:") # .grid(row=1, column=0)
        print("scrolline="+str(scrolline))
        edcom = ScrolledText(self.frame, height=scrolline) #; st.grid(row=1, column=1)
        edcom.insert(tk.END, comtxt)
        edcom.pack()
        edcom.focus_set()
        bsave = tk.Button(self.frame, text="Save Comment", width=20, bg="pink", command=myget)
        bsave.pack()


    def next(self):
        global counter
        global idx
        global timg
        global maxw
        global maxh
        global edcom
        global fname
        global namlbl
        global scrolline
        self.frame.destroy()
        self.frame=tk.Frame(self.top, takefocus=True)
        self.frame.pack()
        counter = counter+1
        idx = counter % nimg
        fname=str(jpglist[idx])
        comtxt=mycom(fname)
        print("NEXT Opening "+fname)
        img=Image.open(fname)
        [wsize, hsize]=myimsize(img)
        timg = img.resize((wsize,hsize), Image.ANTIALIAS)
        timg=ImageTk.PhotoImage(timg)
        self.namfram=tk.Frame(self.frame, takefocus=True) # ? do we need focus
        self.namfram.pack(side=tk.TOP)
        dtxtL=str(fname)
        vnam=tk.StringVar(self.namfram, dtxtL)
        namlbl=tk.Entry(self.namfram, textvariable=vnam, bg="Blue", fg="White")
        namlbl.pack(side=tk.LEFT)
        rbut=tk.Button(self.namfram, text=" Rename ", command=frenam)
        rbut.pack(side=tk.LEFT)
        dimg=tk.Label(self.frame, image=timg)
        dimg.image=timg # keeping a reference (needed!!??)
        dimg.pack()
        # Add comment edit
        edcom=tk.Label(self.frame, text="ScrolledText Box:") # .grid(row=1, column=0)
        edcom = ScrolledText(self.frame, height=scrolline) #; st.grid(row=1, column=1)
        edcom.insert(tk.END, comtxt)
        edcom.pack()
        edcom.focus_set()
        bsave = tk.Button(self.frame, text="Save Comment", width=20, bg="pink", command=myget)
        bsave.pack()

    def prev(self):
        global counter
        global idx
        global timg
        global maxw
        global maxh
        global edcom
        global fname
        global namlbl
        global scrolline
        self.frame.destroy()
        self.frame=tk.Frame(self.top, takefocus=True)
        self.frame.pack()
        counter = counter - 1
        idx = counter % nimg
        fname=str(jpglist[idx])
        comtxt=mycom(fname)
        print("PREV Opening "+fname)
        img=Image.open(fname)
        [wsize, hsize]=myimsize(img)
        timg = img.resize((wsize,hsize), Image.ANTIALIAS)
        timg=ImageTk.PhotoImage(timg)
        self.namfram=tk.Frame(self.frame, takefocus=True) # ? do we need focus
        self.namfram.pack(side=tk.TOP)
        dtxtL=str(fname)
        vnam=tk.StringVar(self.namfram, dtxtL)
        namlbl=tk.Entry(self.namfram, textvariable=vnam, bg="Blue", fg="White")
        namlbl.pack(side=tk.LEFT)
        rbut=tk.Button(self.namfram, text=" Rename ", command=frenam)
        rbut.pack(side=tk.LEFT)
        dimg=tk.Label(self.frame, image=timg)
        dimg.image=timg # keeping a reference (needed!!??)
        dimg.pack()
        # Add comment edit
        edcom=tk.Label(self.frame, text="ScrolledText Box:") # .grid(row=1, column=0)
        edcom = ScrolledText(self.frame, height=scrolline) #; st.grid(row=1, column=1)
        edcom.insert(tk.END, comtxt)
        edcom.pack()
        edcom.focus_set()
        bsave = tk.Button(self.frame, text="Save Comment", width=20, bg="pink", command=myget)
        bsave.pack()

root=tk.Tk()
scrw = str(root.winfo_screenwidth())
scrh = str(root.winfo_screenheight())
print("Screen is "+scrh+" high by "+scrw+" wide")
maxh= int(shf*float(scrh))
maxw=int(swf*float(scrw))
print("Max w and h for screen: "+str(maxw)+" "+str(maxh))
wgeo = str(maxw)+"x"+str(maxh)+"+10+10"
print("wgeo="+wgeo)
root.geometry(wgeo) # We have set the window size

DT=ReplaceTest(root)
root.mainloop()
