library(rgl)
r3dDefaults$windowRect <- c(0,50, 700, 700)


# Demo 3a

f <- function(x, y) ((x-y)^2 + (x-2)^2 + (y-3)^4)/100

x <- seq(0,10,len=20)
y <- seq(0,10,len=20)
z <- outer(x, y, f)

x <- seq(0,5,len=20)
y <- seq(0,5,len=20)
z <- outer(x, y, f)

contour(x,y,z,xlab="x",ylab="y")

# Demo 3b

showsurface <- function(x, y, z) {
  persp3d(x,y,z, col="red", alpha=0.3, axes=F)
  contours <- contourLines(x,y,z)
  for (i in 1:length(contours)) 
    with(contours[[i]], lines3d(x, y, level, col="darkred"))
}
open3d()
showsurface(x,y,z)

# Demo 4a

showsimplex <- function(x, f, col="blue") {
  n <- nrow(x)
  z <- numeric(n)
  for (i in 1:n) z[i] <- f(x[i,])
  xyz <- cbind(x, z)
  
  # This is tricky:  
  
  # 1. draw all lines, taking vertices two at a time:
  segments3d(xyz[as.numeric(combn(n, 2)),])
  # 2. draw all faces, taking vertices three at a time:
  triangles3d(xyz[as.numeric(combn(n, 3)),], col=col, alpha=0.3)
}

neldermead <- function(x, f) {
  n <- nrow(x)
  p <- ncol(x)
  
  if (n != p + 1) stop(paste('Need', p + 1, 'starting points'))
  
  fx <- rep(NA, n)
  for (i in 1:n) fx[i] <- f(x[i,])

  o <- order(fx)
  fx <- fx[o]
  x <- x[o,]
  xmid <- apply(x[1:p,], 2, mean)
  z1 <- xmid - (x[n,] - xmid)
  fz1 <- f(z1)

  if (fz1 < fx[1]) {
    z2 <- xmid - 2*(x[n,] - xmid)
    fz2 <- f(z2)
    if (fz2 < fz1) {
       cat('Accepted reflection and expansion, f(z2)=',fz2,'\n')
       x[n,] <- z2
    } else {
       cat('Accepted good reflection, f(z1)=',fz1,'\n')
       x[n,] <- z1
    }
  } else if (fz1 < fx[p]) {
     cat('Accepted okay reflection, f(z1)=',fz1,'\n')
     x[n,] <- z1
  } else {
    if (fz1 < fx[n]) {
      x[n,] <- z1
      fx[n] <- fz1
    }
    z3 <- xmid + (x[n,] - xmid)/2
    fz3 <- f(z3)
    if (fz3 < fx[n]) {
      cat('Accepted contraction 1, f(z3)=',fz3,'\n')
      x[n,] <- z3
    } else {
      cat('Accepted contraction 2,')
      for (i in 2:n) {
        x[i,] <- x[1,] + (x[i,] - x[1,])/2
        cat(' f(z', i+2, ') = ', f(x[i,]), sep='')
      }
      cat('\n')
    }
  }
  return(x)
}


library(misc3d)

# Example taken from ?contour3d
#Example 2: Nested contours of mixture of three tri-variate normal densities
nmix3 <- function(x, y, z, m, s) {
    0.4 * dnorm(x, m, s) * dnorm(y, m, s) * dnorm(z, m, s) +
    0.3 * dnorm(x, -m, s) * dnorm(y, -m, s) * dnorm(z, -m, s) +
    0.3 * dnorm(x, m, s) * dnorm(y, -1.5 * m, s) * dnorm(z, m, s)
}
f <- function(x,y,z) nmix3(x,y,z,.5,.5)
g <- function(n = 40, k = 5, alo = 0.1, ahi = 0.5, cmap = heat.colors) {
    th <- seq(0.05, 0.2, len = k)
    col <- rev(cmap(length(th)))
    al <- seq(alo, ahi, len = length(th))
    x <- seq(-2, 2, len=n)
    contour3d(f,th,x,x,x,color=col,alpha=al)
    bg3d(col="white")
}

f3 <- function(x) -f(x[1], x[2], x[3])

set.seed(3)

open3d(zoom=0.74,windowRect = c(0,0, 800, 800))
g(40,5)                
xyz <- matrix(rnorm(12, sd=0.1) + rep(rnorm(3,sd=2), each=4), 4, 3)
showsimplex(xyz, f3)

# Demo 4b

for (i in 1:30) {
  xyz <- neldermead(xyz,f3); showsimplex(xyz, f3, "blue")
  Sys.sleep(1)
}

# Demo 4c
set.seed(3)
xyz <- -matrix(rnorm(12, sd=0.1) + rep(rnorm(3,sd=2), each=4), 4, 3)
showsimplex(xyz, f3, "green")
for (i in 1:30) {
  xyz <- neldermead(xyz,f3); showsimplex(xyz, f3, "green")
  Sys.sleep(1)
}

# Demo 5a

f <- function(x, y) ((x-y)^2 + (x-2)^2 + (y-3)^4)/100

# We'll minimize this by setting both partial derivatives to zero.

fx <- function(x, y) (2*(x-y) + 2*(x-2))/100
fy <- function(x, y) (-2*(x-y) + 4*(y-3)^3)/100

fxx <- function(x, y) 4/100
fxy <- function(x, y) -2/100

fyx <- fxy
fyy <- function(x, y) (2 + 12*(y-3)^2)/100

# Make this function more flexible than last time, to allow us to
# show two different functions at once

showsurface <- function(x, y, f, col="red", add=FALSE) {
  z <- outer(x, y, f)
  results <- persp3d(x,y,z, col=col, alpha=0.3, add=add, box=FALSE)
  contours <- contourLines(x,y,z)
  for (i in 1:length(contours)) 
    results <- c(results, with(contours[[i]], lines3d(x, y, level, col=col)))
  invisible(results)
}
x <- seq(0,10,len=20)
y <- seq(0,5,len=20)
open3d()
showsurface(x,y,f)

# Demo 5b

# Compute a quadratic approximation to a function at a given point

quadApprox <- function(x0, y0) {
  f0 <- f(x0, y0)
  fx0 <- fx(x0, y0)
  fy0 <- fy(x0, y0)
  fxx0 <- fxx(x0, y0)
  fxy0 <- fxy(x0, y0)
  fyy0 <- fyy(x0, y0)
  
  function(x, y) {
    f0 + 
    (x - x0)*fx0 +
    (y - y0)*fy0 +
    0.5*(x-x0)^2*fxx0 +
    (x-x0)*(y-y0)*fxy0 +
    0.5*(y-y0)^2*fyy0
  }
}

# We want to be able to delete some parts of the figure; store those in temp
temp <- c()

# Initialize at (0,0)
x1 <- 0
y1 <- 0

# Here's the part we'll repeat in a loop:  
#  Set the old values as starting points;
#  delete the old parts of the figure;
#  show the new quadratic approximation;
#  use Newton-Raphson to move to the new guess
#    at a minimum

x0 <- x1
y0 <- y1
rgl.pop(id=temp)

points3d(x0, y0,f(x0,y0)) ; temp <- showsurface(x,y, quadApprox(x0,y0), col="gray", add=TRUE)

d <- fxx(x0, y0)*fyy(x0, y0) - fxy(x0, y0)*fyx(x0, y0)
x1 <- x0 - (fyy(x0, y0)*fx(x0, y0) - fxy(x0, y0)*fy(x0, y0))/d                
y1 <- y0 - (fxx(x0, y0)*fy(x0, y0) - fyx(x0, y0)*fx(x0, y0))/d
lines3d(c(x0, x1), c(y0, y1), c(f(x0, y0), f(x1, y1)))
print(c(x1,y1,f(x1,y1)))


# Demo 5c

# Next step of the loop:

x0 <- x1
y0 <- y1
rgl.pop(id=temp)

points3d(x0, y0,f(x0,y0)) ; temp <- showsurface(x,y, quadApprox(x0,y0), col="gray", add=TRUE)

d <- fxx(x0, y0)*fyy(x0, y0) - fxy(x0, y0)*fyx(x0, y0)
x1 <- x0 - (fyy(x0, y0)*fx(x0, y0) - fxy(x0, y0)*fy(x0, y0))/d                
y1 <- y0 - (fxx(x0, y0)*fy(x0, y0) - fyx(x0, y0)*fx(x0, y0))/d
lines3d(c(x0, x1), c(y0, y1), c(f(x0, y0), f(x1, y1)))
print(c(x1,y1,f(x1,y1)))
