railss<-function(xx){ # SPMA rail problem to provide sumsquares of residuals
    r<-xx[1]
    p<-xx[2] # get the two parameters
    e1<-r*sin(p)-2640
    e2<-r*p-2640.5
    ss<-e1*e1+e2*e2
}


# test spma-nm.R
# J C Nash 111004
x<-c(70000, 0.04) # reasonable start (from crude solution?)
ans<-optim(x, railss, control=list(trace=1))
print(ans)
rr<-ans$par[1]
pp<-ans$par[2]
AA<-4 + 8.5/12 +  rr*(1-cos(pp)) 
cat("rail distance = ",AA,"\n")
tmp<-readline("continue with scaled function?")

ans2<-optim(x, railss, control=list(trace=1, parscale=c(1E+4, 1E-2)))
print(ans2)
rr<-ans2$par[1]
pp<-ans2$par[2]
AA2<-4 + 8.5/12 +  rr*(1-cos(pp))
cat("rail distance = ",AA2, "\n")
cat("diff = ",AA2-AA,"\n")
tmp<-readline("continue with differently scaled function?")
ans3<-optim(x, railss, control=list(trace=1, parscale=c(1E-4, 1E+2)))
print(ans3)
rr<-ans3$par[1]
pp<-ans3$par[2]
AA3<-4 + 8.5/12 +  rr*(1-cos(pp))
cat("rail distance = ",AA3, "\n")
cat("diff = ",AA3-AA,"\n")

cat("\n\nCheck from ans values\n")
x1<-ans$par
#ans4<-optim(x1, railss, control=list(trace=1, parscale=c(1E4, 1E-2)))
tmp<-readline("restart from first answer?")

ans4<-optim(x1, railss, control=list(trace=1, maxit=50000))
print(ans4)
rr<-ans4$par[1]
pp<-ans4$par[2]
AA4<-4 + 8.5/12 +  rr*(1-cos(pp))
cat("rail distance = ",AA4, "\n")
cat("diff = ",AA4-AA,"\n")
