#!/bin/bash
# weaver -- to demonstrate SWeave / odfWeave functions
rm myreport.pdf # just in case -- clear the work area
echo "First let us try Latex and Sweave"
echo "What does the source file (myreport.Rnw) look like?"
read TMP
gedit myreport.Rnw
echo ""
echo "And we need to supply an end date for the report in file curr.txt"
cp curr1103.txt curr.txt
cat curr.txt
echo ""
echo "This has to be converted to a TeX file with Sweave"
read TMP
R CMD Sweave myreport.Rnw
echo ""
echo "giving us a file myreport.tex"
read TMP
gedit myreport.tex
echo ""
echo "We process this with LaTeX in the usual way i.e.,"
#  Note that if there are bibliographies or special codes to process
#   we may need to run latex and bibtex and ... multiple times. Moreover
#   the pdf graphics generated here may NOT work properly in Latex which
#   uses eps graphics as default.
read TMP
pdflatex myreport.tex
echo ""
echo "And view the result"
read TMP
evince myreport.pdf
echo ""
cp myreport.pdf myreport1103.pdf
echo "Now change the end date"
cp curr1109.txt curr.txt
cat curr.txt
echo ""
echo "This has to be converted to a TeX file with Sweave"
# read TMP
R CMD Sweave myreport.Rnw
pdflatex myreport.tex
evince myreport.pdf
echo ""
cp myreport.pdf myreport1109.pdf
echo ""
#######################################################
echo "Now do the same with odfWeave"
rm MyOut.odt # just in case
echo "What does the source file (MyReport.odt) look like?"
read TMP
libreoffice MyReport.odt
echo ""
echo "And we need to supply an end date for the report in file curr.txt"
cp curr1103.txt curr.txt
cat curr.txt
echo ""
echo "This has to be processed with odfWeave inside R"
read TMP
R --vanilla <runoweave.R
echo ""
echo "giving us a file MyOut.odt"
read TMP
libreoffice MyOut.odt
echo ""
cp MyOut.odt MyOut03.odt
cp curr1109.txt curr.txt
cat curr.txt
R --vanilla <runoweave.R
libreoffice MyOut.odt
echo ""
cp MyOut.odt MyOut09.odt
